/*! \file    
**********************************************************************************	
* Title:						Discretix SST API Source file						 					
*																			
* Filename:						sst_api_init_terminate.c															
*																			
* Project, Target, subsystem:	SST Host IF, APIs
* 
* Created:						01.07.2007													
*
* Modified:						07.06.2007										
*
* \Author						Ira Boguslavsky														
*																			
* \Remarks						
*           Copyright (C) 2006 by Discretix Technologies Ltd. All Rights reserved.
**********************************************************************************/

/*----------- External include files ----------------------------------------*/
#include "DX_VOS_Mem.h"
#include "SEPDriver.h"
#include "error.h"
#include "sst_errors.h"
#include "sst_sep_errors.h"
#include "sst_types.h"
#include "sst_utility.h"
#include "NVS.h"
#include "sst_host_util.h"
#include "sst_host_def.h"
/*----------- Local include files -------------------------------------------*/
#include "sst_test_flags.h"
#include "sst_host_op_code.h"
/*----------- Local include files -------------------------------------------*/
/*----------- Local Variable declarations -----------------------------------*/
/*----------- Local function declarations -----------------------------------*/
/*----------- Local constant definitions  -----------------------------------*/

/*---------------------------------------------------------------------------*/

/* id of the main file */
#define SST_MAIN_FILE_MEMORY_ID       1

/* id of the secondary file */
#define SST_SECONDARY_FILE_MEMORY_ID  2

/*---------------------------------------------------------------------------*/
/*               API FUNCTIONS                                               */
/*---------------------------------------------------------------------------*/

 /*General services*/

/*SST_Init*/	
DxError_t SST_Init(DxNvsMemoryId_t  aSSTMainMemoryId, 
        				   DxNvsMemoryId_t  aSSTSecondaryMemoryID,
        				   SSTInitInfo_t*   aInitInfo_ptr,
        				   DxByte_t*        aWorkspace_ptr,
        				   DxUint32_t       aWorkspaceSizeInBytes)
{
  DxUint32_t    paramInBuffer_ptr [DX_6_WORDS_PARAMS];
  DxUint32_t    paramOutBuffer_ptr[DX_4_WORDS_PARAMS];
  DxError_t     errorRC;
	DxUint32_t    dbPagesMemPhysAdd;
	DxUint32_t    dbPagesMemVirAdd;

  /*-------------------------
      CODE
  -----------------------------*/

  /* Eliminating warnings regarding useless variables */
  aWorkspace_ptr = aWorkspace_ptr;
  aWorkspaceSizeInBytes = aWorkspaceSizeInBytes;

  if(DX_IS_NULL_2PARAMS(aSSTMainMemoryId, aSSTSecondaryMemoryID))
  {
    return SST_RC_ERROR_NULL_POINTER;
  }
  
  /* set the NVS mapping */
  errorRC = NVS_InitFile(aSSTMainMemoryId , SST_MAIN_FILE_MEMORY_ID);
  if(errorRC)
  {
    return errorRC;
  }
  
  errorRC = NVS_InitFile(aSSTSecondaryMemoryID , SST_SECONDARY_FILE_MEMORY_ID);
  if(errorRC)
  {
    return errorRC;
  }
  
  aSSTMainMemoryId = SST_MAIN_FILE_MEMORY_ID;
  aSSTSecondaryMemoryID = SST_SECONDARY_FILE_MEMORY_ID;
  
	/************************************************************************/
	/*  Lock access to SEP                                                  */
	/************************************************************************/
  errorRC = SEPDriver_Lock();
  if(DX_MNG_SEP_IS_DISABLE_ERR == errorRC)
  {
    errorRC = SST_RC_ERROR_SEP_DISABLED; 
    goto exit_function;
  }
  else if (DX_OK != errorRC)
  {
    errorRC = SST_RC_ERROR_SEP; 
    goto exit_function;
  }
  /************************************************************************/
  /* Prepare input buffer                                                 */
  /************************************************************************/
  /*get the DB page pointer, size required is SST_UTIL_DB_PAGES_MEMORY_SIZE_IN_BYTES*/
	SEPDriver_GetStaticMemoryAddr(&dbPagesMemPhysAdd,&dbPagesMemVirAdd);

	paramInBuffer_ptr[0] = SST_SEP_OP_CODE_INIT;
  paramInBuffer_ptr[1] = (DxUint32_t)aSSTMainMemoryId;
  paramInBuffer_ptr[2] = (DxUint32_t)aSSTSecondaryMemoryID;
  paramInBuffer_ptr[3] = (DxUint32_t)aInitInfo_ptr;
	paramInBuffer_ptr[4] = (DxUint32_t)dbPagesMemPhysAdd;
	paramInBuffer_ptr[5] = SST_UTIL_DB_PAGES_MEMORY_SIZE_IN_BYTES;

  /************************************************************************/
  /* Send an input buffer to SeP and wait for output parameters          */
  /************************************************************************/
  errorRC = SST_SendOneMsgGetResponse( paramInBuffer_ptr,
                                        /* Input buffer length */
                                        DX_6_WORDS_PARAMS * sizeof(DxUint32_t), 
                                        paramOutBuffer_ptr,
                                        /* Output buffer maximal length */
                                        DX_4_WORDS_PARAMS * sizeof(DxUint32_t));
  if (DX_OK != errorRC)
  {
    goto exit_init;
  }

  /************************************************************************/
  /* Analyze return buffer                                                */
  /************************************************************************/
  /* Op code */
  if (paramOutBuffer_ptr[0] != SST_SEP_OP_CODE_INIT)
  {
    errorRC = SST_RC_ERROR_SEP;
    goto exit_init;
  }

  /* RC */    
  errorRC = paramOutBuffer_ptr[1];
  
  /* check if the SST was already initialized */
  if(errorRC == SST_RC_ERROR_ALREADY_INITIALIZED)
  {
    errorRC = SST_RC_OK;
    goto exit_init;
  }
  
	SST_HOST_RETURN_CODE_CHECK(errorRC,exit_init);
	
	if (DX_NULL != aInitInfo_ptr)
	{
		aInitInfo_ptr->powerDownRecover = (DxBool_t)paramOutBuffer_ptr[2];
    aInitInfo_ptr->newDatabase = (DxBool_t)paramOutBuffer_ptr[3];
	}
	
exit_init:
	/************************************************************************/
	/* UnLock access to  SEP                                                  */
	/************************************************************************/
	SEPDriver_Unlock();

exit_function:
     
    return errorRC;
}

/*SST_Terminate*/
DxError_t SST_Terminate(void)
{
    DxUint32_t              paramInBuffer_ptr[DX_1_WORD_PARAM];
    DxUint32_t              paramOutBuffer_ptr[DX_2_WORDS_PARAMS];
    DxError_t               errorRC;

	/************************************************************************/
	/*  Lock access to SEP                                                  */
	/************************************************************************/
   errorRC = SEPDriver_Lock();
   if(DX_MNG_SEP_IS_DISABLE_ERR == errorRC)
   {
       errorRC = SST_RC_ERROR_SEP_DISABLED; 
       goto exit_function;
   }
   else if (DX_OK != errorRC)
   {
       errorRC = SST_RC_ERROR_SEP; 
       goto exit_function;
   }
	/************************************************************************/
    /* Prepare input buffer                                                 */
    /************************************************************************/
    /* Operation Code */
    paramInBuffer_ptr[0] = SST_SEP_OP_CODE_TERMINATE;

    /************************************************************************/
    /* Send an input buffer to SeP and wait for output parameters           */
    /************************************************************************/
    errorRC = SST_SendOneMsgGetResponse( paramInBuffer_ptr,
                                        /* Input buffer length */
                                        DX_1_WORD_PARAM * sizeof(DxUint32_t), 
                                        paramOutBuffer_ptr,
                                        /* Output buffer maximal length */
                                        DX_2_WORDS_PARAMS * sizeof(DxUint32_t));
    if (DX_OK != errorRC)
        goto exit_terminate;

    /************************************************************************/
    /* Analyze return buffer                                                */
    /************************************************************************/
    /* Op code */
    if (paramOutBuffer_ptr[0] != SST_SEP_OP_CODE_TERMINATE)
    {
        errorRC = SST_RC_ERROR_SEP;
        goto exit_terminate;
    }

    /* RC */    
	errorRC = paramOutBuffer_ptr[1];
	SST_HOST_RETURN_CODE_CHECK(errorRC,exit_terminate);

exit_terminate:  
	/************************************************************************/
	/* UnLock access to  SEP                                                  */
	/************************************************************************/
	SEPDriver_Unlock();

exit_function:
   
    return errorRC;
}



